require( "scripts/style.lua" )


kStartX = 125;
kHeaderY = 130;
kRow1Y = 165;
kRow2Y = 400;
kHorizontalSpacing = 300;
kVerticalSpacing = 65;
kTextXOffset = 70;
kTextWidth = 150;
kHeaderPaddingX = 10;
kHeaderPaddingY = 4;
kHeaderVerticalSpacing = 40;

MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/helppage",	
		x=kCenter,
		y=kCenter,

		Text
		{
			font = HelpTableInfoFont,
			name = "help",
			x=0,y=8,w=kMax ,h=kMax,
			flags = kHAlignCenter+ kVAlignTop,
			label = "ui.dialog.help.title"
		};
		
		Button{
			x = kCenter - 70,
			y = 497,
			--flags = + ,
			font = StandardButtonFont,
			graphics = HelpLeftButtonGraphics,
			name="previous",
			type = kPush,
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			command=
				function()
					PopModal();
					DoModal("scripts/helpmenu2.lua");
				end
		};
		
		Text
		{			
			x=kCenter,
			y=457,
			w=kMax ,h=kMax,
			flags = kHAlignCenter+ kVAlignCenter,
			font = { standardFont, 20, BlackColor };
			name = "help",
			label = "help_paginate_3",
		};

		Button{
			x = kCenter + 70,
			y = 497,
			font = StandardButtonFont,
			graphics = HelpRightButtonGraphics,
			name="next",
			type = kPush,
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			command=
				function()
					PopModal();
					DoModal("scripts/helpmenu4.lua");
				end
		};
			
		Button{
			--flags = kHAlignCenter+ kVAlignBottom,
			x = kCenter+250,
			y = 501,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="ok",
			rolloversound = "assets/audio/sfx/dialog_roll.ogg",
			sound = "assets/audio/sfx/dialog_click.ogg",
			label="close",
			type = kPush,
			close=true
		};
		
		
		-- DISASTERS HEADER
		Bitmap
		{ 
			image="images/helpscreen/headerbg",	
			x=kStartX,
			y=kHeaderY-kHeaderVerticalSpacing,
		};
		Text
		{			
			x=kStartX+kHeaderPaddingX,
			y=kHeaderY-kHeaderVerticalSpacing+kHeaderPaddingY,
			w=kMax ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpHeaderFont;
			name = "help",
			label = "help_header_disasters",
		};
		Text
		{			
			x=kStartX+kHeaderPaddingX,
			y=kHeaderY-kHeaderVerticalSpacing+kHeaderPaddingY + 30,
			w=500 ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_disaster_description",
		};
		
		
		-- DOG
		Bitmap
		{ 
			image="images/helpscreen/dog",	
			x=kStartX + (kHorizontalSpacing*0),
			y=kRow1Y,
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*0) + kTextXOffset,
			y=kRow1Y,
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_disaster_dog",
		};
		
		--BRIDEZILLA
		Bitmap
		{ 
			image="images/helpscreen/bridezilla",	
			x=kStartX + (kHorizontalSpacing*1),
			y=kRow1Y,
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*1) + kTextXOffset,
			y=kRow1Y,
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_disaster_bridezilla",
		};
		
		
		-- BRIDESMAINDS
		Bitmap
		{ 
			image="images/helpscreen/bridesmaids",	
			x=kStartX + (kHorizontalSpacing*0),
			y=kRow1Y+(kVerticalSpacing*1),
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*0) + kTextXOffset,
			y=kRow1Y+(kVerticalSpacing*1),
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_disaster_bridesmaids",
		};
		
		--SPEAKERWIRE
		Bitmap
		{ 
			image="images/helpscreen/speakerwire",	
			x=kStartX + (kHorizontalSpacing*1),
			y=kRow1Y+(kVerticalSpacing*1),
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*1) + kTextXOffset,
			y=kRow1Y+(kVerticalSpacing*1),
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_disaster_speakerwire",
		};
		
		
		-- TIPPINGCAKE
		Bitmap
		{ 
			image="images/helpscreen/cake",	
			x=kStartX + (kHorizontalSpacing*0),
			y=kRow1Y+(kVerticalSpacing*2),
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*0) + kTextXOffset,
			y=kRow1Y+(kVerticalSpacing*2),
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_disaster_tippingcake",
		};
		
		--CHEF TABLE FIRE
		Bitmap
		{ 
			image="images/helpscreen/smoke",	
			x=kStartX + (kHorizontalSpacing*1),
			y=kRow1Y+(kVerticalSpacing*2),
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*1) + kTextXOffset,
			y=kRow1Y+(kVerticalSpacing*2),
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_disaster_cheftablefire",
		};
		
		
		-- AUNT CRYING
		Bitmap
		{ 
			image="images/helpscreen/auntcry",	
			x=kStartX + (kHorizontalSpacing*0),
			y=kRow1Y+(kVerticalSpacing*3),
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*0) + kTextXOffset,
			y=kRow1Y+(kVerticalSpacing*3),
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_disaster_auntcrying",
		};
		
		--BEES
		Bitmap
		{ 
			image="images/helpscreen/bees",	
			x=kStartX + (kHorizontalSpacing*1),
			y=kRow1Y+(kVerticalSpacing*3),
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*1) + kTextXOffset,
			y=kRow1Y+(kVerticalSpacing*3),
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_disaster_bees",
		};
		
		
		-- DRUNK UNCLE
		Bitmap
		{ 
			image="images/helpscreen/uncledrunk",	
			x=kStartX + (kHorizontalSpacing*0),
			y=kRow1Y+(kVerticalSpacing*4),
		};
		Text
		{			
			x=kStartX + (kHorizontalSpacing*0) + kTextXOffset,
			y=kRow1Y+(kVerticalSpacing*4),
			w=kTextWidth ,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			font = HelpFont;
			name = "help",
			label = "help_disaster_drunkuncle",
		};
		
	}
}



